#include "Photoshop.au3"

$oPs = _Photoshop_Create()

; Open an example image
$oDoc = _Photoshop_DocOpen($oPs, @ScriptDir&"\Test image.psd")

; List all layers
For $oLayer In _Photoshop_DocGetLayers($oDoc)
	$sName = _Photoshop_LayerGetName($oLayer)
	$iOpacity = _Photoshop_LayerGetOpacity($oLayer)
	$bIsBackground = _Photoshop_ArtLayerIsBackgroundLayer($oLayer)
	MsgBox(0, "Layer info", "Name:"&@TAB&@TAB&$sName&@CRLF&"Opacity:"&@TAB&@TAB&$iOpacity&@CRLF&"Background?"&@TAB&$bIsBackground)
Next

; Set "Green" layer opacity to 100%
$oGreenLayer = _Photoshop_DocGetLayer($oDoc, 1) ; indices in Photoshop start from 1, not 0!
_Photoshop_LayerSetOpacity($oGreenLayer, 100)

; Uncomment to close the document
; _Photoshop_DocClose($oDoc)

; Uncomment to close Photoshop
; _Photoshop_Quit($oPs)